﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager;
using VeteransAffairs.Registries.BusinessManager.Utilities;
using VeteransAffairs.Registries.BusinessManager.EFR;
using System.Text.RegularExpressions;
using System.Web.Security.AntiXss;

public partial class DoDFragmentAnalyteDelete : BasePage
{
    private DoDFragmentManager _manager = new DoDFragmentManager();
    protected readonly string DoDFragmentPage = "DoDFragment.aspx?patientId=";
                                                 
    protected void Page_Load(object sender, EventArgs e)
    {
        HiddenFieldPatientID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["patientId"], false);
        HiddenFieldAnalyteID.Value = AntiXssEncoder.HtmlEncode(Request.QueryString["dodFragmentAnalyteId"], false);

        DOD_FRAGMENT_DETAIL analyte = _manager.GetFragmentAnalyteById(Helpers.getIntFromString(HiddenFieldAnalyteID.Value));
        analyte.SetAsChangeTrackingRoot();
        analyte.SetAsDeleteOnSubmit();

        _manager.Update(analyte);

        //Response.Redirect(String.Format("DoDFragment.aspx?patientId={0}",
        //    GetQueryStringValue(HiddenFieldPatientID.Value)));

        ResponseRedirect(DoDFragmentPage, GetQueryStringValue(HiddenFieldPatientID.Value));
    }

    public override string TopMenuName()
    {
        return "Patients";
    }

    public override string AppObjectCode()
    {
        return "EFR_PATIENTS";
    }

    public override string MenuItemName()
    {
        return "EFR_PATIENTS";
    }

    private string GetQueryStringValue(string patientID)
    {
        string vldPatientId = string.Empty;
        try
        {
            if (IsQueryStringValid(patientID))
            {
                vldPatientId = patientID.ToString();
            }
        }
        catch (Exception)
        {
            Logging.WriteLogToFile("Error parsing request data.");
        }
        return vldPatientId;
    }

    private bool IsQueryStringValid(string patientID)
    {
        bool isStringValid = false;
        if (patientID != null)
        {
            if (Regex.IsMatch(patientID.ToString(), "^[a-zA-Z0-9]*$"))
            {
                isStringValid = true;
            }
        }
        return isStringValid;
    }

    private void ResponseRedirect(string destination, string queryString)
    {
        try
        {
            string queryStringValue = string.Empty;
            if (queryString != null)
            {
                queryStringValue = AntiXssEncoder.UrlEncode(queryString);
            }

            string destinationUrl = string.Concat(destination, queryStringValue);
            string currentHost = Request.Url.Host;
            if (Helpers.IsDestinationUrlLocal(destinationUrl, currentHost))
            {
                //Response.Redirect(destinationUrl);
                Server.Transfer(destinationUrl);
            }
        }
        catch (Exception ex)
        {
            Logging.WriteLogToFile("Failure in to redirect to Export page: - DOD Fragment page.");
        }

    }
}